#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1


. /etc/sysconfig/network
. /etc/rc.d/init.d/network_functions

RESOLV_CONF="/tmp/resolv.conf"

[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

case "$1" in
	deconfig)
		/sbin/ifconfig $interface 0.0.0.0
		notify_interface_disconnect $interface
		;;

	renew|bound)
		/sbin/ifconfig $interface $ip $BROADCAST $NETMASK

		if [ -n "$router" ] ; then
			for i in $router ; do
				echo "$i" > /tmp/gateway.$interface
			done
		fi

		echo -n > $RESOLV_CONF.$interface
		[ -n "$domain" ] && echo search $domain >> $RESOLV_CONF.$interface
		for i in $dns ; do
			echo adding dns $i
			echo nameserver $i >> $RESOLV_CONF.$interface
		done

		add_default_route_and_resolv $interface

		case "$1" in
			bound)
				if [ ${VPN}=="yes" ]; then
					# Force a restart (knet will detect the loss of the Process and restart it) of OpenVPN
					# after an interface (re)-start (specially in case of bearer change)
					killall openvpn
				fi
				;;
		esac

		n=1
		nn=2
		if [ -n "$staticroutes" ] ; then
			for i in $staticroutes ; do
				net=$(echo $staticroutes | cut -d ' ' -f$n)
				router=$(echo $staticroutes | cut -d ' ' -f$nn)
				if [ -z $net ] ; then
					break
				fi
				echo adding net $net with router $router
				route add -net $net gw $router
				n=$((n+2))
				nn=$((nn+2))
			done
		fi
		;;

esac

exit 0
