#!/bin/sh

MOUNT_POINT=$1
TAG=ran_pkg_install

# ------------------------------------------------------------------------------------------
# Cleanup of previous installs
# ------------------------------------------------------------------------------------------
#rm -f ${MOUNT_POINT}/produsb.log
rm -f ${MOUNT_POINT}/*openvpn*.tar.gz
rm -f ${MOUNT_POINT}/*openvpn*.ipk

# ------------------------------------------------------------------------------------------
# RAN VPN provisioning
# ------------------------------------------------------------------------------------------
hostname_lc=$(hostname | grep -oE '.{7}$' | tr '[:upper:]' '[:lower:]')

# Check if USB key already has the VPN package at the root, if that's the case then abort
local_pkg=$(ls ${MOUNT_POINT}/*${hostname_lc}*)
if [ "${local_pkg}" != "" ] && [ -f ${local_pkg} ]; then
	logger -t ${TAG} "USB key has already provisioned this station; ignore"
	rm -f ${local_pkg}
	exit 0
fi

# Pick target VPN package
vpn_pkg=$(ls ${MOUNT_POINT}/vpn_packages/*${hostname_lc}*)
if [ $(echo "${vpn_pkg}" | wc -l) != 1 ]; then
	logger -t ${TAG} "unable to find one VPN package suitable for ${hostname_lc}"
	exit 1
fi

# Copy at the root of the USB key
logger -t ${TAG} "using file ${vpn_pkg} for board ${hostname_lc}"
cp -v ${vpn_pkg} ${MOUNT_POINT}/ | logger -t ${TAG}
# ------------------------------------------------------------------------------------------


# ------------------------------------------------------------------------------------------
# Default autorun / prod USB
# ------------------------------------------------------------------------------------------
logger -t ${TAG} "trigger prod USB"
mv ${MOUNT_POINT}/_produsb.sh ${MOUNT_POINT}/produsb.sh
/usr/local/bin/autorun.sh $(echo ${MOUNT_POINT} | awk -F/ '{print $NF}')
